USE [DownloadStatistics]
GO

/****** Object:  Table [dbo].[FileDownload]    Script Date: 7/30/2013 5:13:38 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

CREATE TABLE [dbo].[FileDownload](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[ProjectFileID] [int] NOT NULL,
	[DateDownloaded] [datetime] NOT NULL,
	[Referrer] [nvarchar](4000) NULL,
	[UserAgent] [nvarchar](4000) NULL,
	[IPAddress] [varbinary](16) NOT NULL,
	[Status] [tinyint] NOT NULL,
 CONSTRAINT [PK_ProjectFileDownload] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO

ALTER TABLE [dbo].[FileDownload] ADD  CONSTRAINT [DF_FileDownload_Status]  DEFAULT ((1)) FOR [Status]
GO

EXEC sys.sp_addextendedproperty @name=N'EnumValues', @value=N'1:New;2:Processing;3:Processed' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FileDownload', @level2type=N'COLUMN',@level2name=N'Status'
GO


